<?php
// Removed Access-Control-Allow headers as this will be a direct form submission with redirect
// Removed OPTIONS request handling

require_once 'config.php';
if (!isLoggedIn()) {
    header('Location: login.php');
    exit();
}

// Initialize messages
$success_message = '';
$error_message = '';

// Retrieve messages from session if they exist
if (isset($_SESSION['success_message'])) {
    $success_message = $_SESSION['success_message'];
    unset($_SESSION['success_message']);
}
if (isset($_SESSION['error_message'])) {
    $error_message = $_SESSION['error_message'];
    unset($_SESSION['error_message']);
}

// Handle POST request for balance update
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $user_id = $_SESSION['user_id'] ?? null;
    $sentAmount = isset($_POST['sentAmount']) ? floatval($_POST['sentAmount']) : 0;
    $yourNumber = $_POST['yourNumber'] ?? null;
    $paymentMethod = $_POST['paymentMethod'] ?? 'غير محدد';

    if (!$user_id || !$sentAmount || !$yourNumber) {
        $_SESSION['error_message'] = 'يرجى إدخال جميع البيانات المطلوبة';
        header('Location: AddBalance.php');
        exit();
    }

    try {
        $conn = getDBConnection();

        // Update balance directly in users table
        $stmt = $conn->prepare("UPDATE users SET balance = balance + ? WHERE id = ?");
        if ($stmt === false) {
            throw new Exception('Prepare balance update failed: ' . $conn->error);
        }
        $stmt->bind_param('di', $sentAmount, $user_id);
        $stmt->execute();
        $stmt->close();

        // Log the transaction with additional details
        $stmt = $conn->prepare("INSERT INTO transactions (user_id, type, amount, method, description, reference_number, status, created_at) VALUES (?, ?, ?, ?, ?, ?, ?, NOW())");
        if ($stmt === false) {
            throw new Exception('Prepare transaction log failed: ' . $conn->error);
        }
        $transaction_type = 'deposit';
        $transaction_status = 'completed';
        $transaction_description = 'إضافة رصيد بواسطة المحفظة: ' . $yourNumber;

        $stmt->bind_param('isdssss', $user_id, $transaction_type, $sentAmount, $paymentMethod, $transaction_description, $yourNumber, $transaction_status);
        $stmt->execute();
        $stmt->close();

        $_SESSION['success_message'] = 'انتظر خمس دقائق لو متمتش الاضافة ابعت اسكرين شوت علي الواتس اب';
        // إرسال إشعار إلى تليجرام
        $botToken = '7712958701:AAGBAqEYx2gvEPCOHFWVI0aCG_eERK9Ql0U';
        $chatId = '1278161988';
        // جلب اسم المستخدم من الجلسة أو من قاعدة البيانات إذا لم يكن موجودًا
        if (isset($_SESSION['username']) && $_SESSION['username']) {
            $username = $_SESSION['username'];
        } elseif (isset($_SESSION['user_id'])) {
            $connUser = getDBConnection();
            $stmtUser = $connUser->prepare("SELECT username FROM users WHERE id = ?");
            $stmtUser->bind_param('i', $_SESSION['user_id']);
            $stmtUser->execute();
            $stmtUser->bind_result($fetched_username);
            if ($stmtUser->fetch()) {
                $username = $fetched_username;
            } else {
                $username = 'غير معروف';
            }
            $stmtUser->close();
            $connUser->close();
        } else {
            $username = 'غير معروف';
        }
        $msg = "💰 إضافة رصيد جديدة%0A";
        $msg .= "المستخدم: $username%0A";
        $msg .= "المبلغ: $sentAmount جنيه%0A";
        $msg .= "الطريقة: $paymentMethod%0A";
        $msg .= "الرقم: $yourNumber%0A";
        $msg .= "التاريخ: ".date('Y-m-d H:i:s');
        @file_get_contents("https://api.telegram.org/bot$botToken/sendMessage?chat_id=$chatId&text=$msg");
    } catch (mysqli_sql_exception $e) {
        $_SESSION['error_message'] = 'حدث خطأ أثناء إضافة الرصيد: ' . $e->getMessage();
    } catch (Exception $e) {
        $_SESSION['error_message'] = 'حدث خطأ غير متوقع: ' . $e->getMessage();
    } finally {
        if (isset($conn) && $conn) {
            $conn->close();
        }
    }
    header('Location: AddBalance.php');
    exit();
}

// If it's a GET request or the POST conditions were not met, proceed to render the HTML.
require_once 'header.php';
?>

<div class="main-content">
    <div class="container mt-5">
        <div class="card shadow-lg p-4 rounded-xl">
            <h2 class="text-center mb-2 fw-bold" style="font-size:2rem;">طريقة الدفع</h2>
            <div class="text-center mb-3 text-light-muted" style="font-size:1.1rem;">
                <span>🔥 فودافون - أورانج - إتصالات - وي / كاش | بدون رسوم</span>
            </div>
            <!-- Display success or error messages -->
            <?php if ($success_message): ?>
                <div class="alert alert-success text-center mb-3"><?= htmlspecialchars($success_message) ?></div>
            <?php endif; ?>
            <?php if ($error_message): ?>
                <div class="alert alert-danger text-center mb-3"><?= htmlspecialchars($error_message) ?></div>
            <?php endif; ?>

            <form method="post" autocomplete="off">
                <div class="mb-4">
                    <h4 class="text-center text-purple-300 fw-bold mb-3">اختر طريقة الدفع</h4>
                    <select name="paymentMethod" id="paymentMethod" class="form-select bg-dark-2 text-white border-secondary text-center mb-3" style="max-width:300px;margin:auto;">
                        <option value="mobile_wallet">فودافون كاش / المحافظ الإلكترونية</option>
                        <option value="bank_transfer">تحويل بنكي / انستاباي</option>
                    </select>
                    <div class="text-center my-3">
                        <img src="vodafon.jpeg" alt="Vodafone Logo" class="mx-auto mb-2" style="width:120px; background:#fff; border-radius:12px; padding:8px;">
                    </div>
                    <div class="text-center mb-2">
                        <span class="text-green fw-bold" style="font-size:1.1rem;">سعر الإيداع اليوم</span>
                        <div class="text-green fw-bold" style="font-size:1.3rem;">(1$ دولار = 51.05 جنيه مصري)</div>
                    </div>
                    <div class="text-center mb-3">
                        <span class="text-gray-300">أرقام المحافظ الخاصه بنا:</span>
                        <div>
                            <a href="tel:+201067761719" class="btn btn-green fw-bold fs-5 mt-2" style="border-radius:2rem;">
                                <span class="me-2">📞</span> 01067761719
                            </a>
                        </div>
                    </div>
                    <div class="bg-dark-2 p-3 rounded mb-3">
                        <div class="fw-bold mb-2 text-white">مثال:</div>
                        <div class="example-input mb-2">إذا كنت تريد إيداع 5 دولار فستقوم بتحويل مبلغ 255.25 جنيه</div>
                        <ol class="list-decimal list-inside text-gray-300" style="direction:rtl;">
                            <li>ارسل المبلغ الي رقم فودافون كاش المذكور في الاعلي أولاً</li>
                            <li>قم بكتابه الرقم الخاص بك الذي قمت بالتحويل لنا من خلاله في الخانه المطلوبه</li>
                            <li>اكتب المبلغ الذي قمت بتحويله في الخانه المطلوبه</li>
                            <li><span class="fw-bold text-white">اضغط علي زر الدفع</span></li>
                        </ol>
                    </div>
                    <div class="alert alert-orange text-center mb-4">
                        إذا فشل الإيداع عليك الانتظار لمدة 5 دقائق ثم حاول مره اخري<br>
                        في حالة <span class="fw-bold text-danger">واجهت اي مشاكل</span>، قم بفتح تذكره دعم جديده او تواصل معنا عبر واتساب
                    </div>
                </div>
                <h4 class="text-center fw-bold mb-3">الرقم الخاص بك</h4>
                <div class="mb-3">
                    <label for="yourNumber" class="form-label">الرقم الخاص بك</label>
                    <input type="text" name="yourNumber" id="yourNumber" class="form-control bg-dark-2 text-white border-secondary" placeholder="مثال: 01000000000" required>
                </div>
                <div class="mb-3">
                    <label for="sentAmount" class="form-label">المبلغ الذي ارسلته (بالجنيه المصري)</label>
                    <input type="number" name="sentAmount" id="sentAmount" class="form-control bg-dark-2 text-white border-secondary" placeholder="مثال: 255.25" required>
                </div>
                <button type="submit" class="btn btn-primary w-100 py-3 fw-bold fs-5 mt-2">اضغط علي زر الدفع</button>
            </form>
        </div>
    </div>
</div>

<?php require_once 'footer.php'; ?><?php
// Removed Access-Control-Allow headers as this will be a direct form submission with redirect
// Removed OPTIONS request handling

